<?php

//-------------------------------------------------
//-- SCRIPT SETTINGS
//-------------------------------------------------

// config file
$config_file = "config.txt";

// forward messages to phones other than your own
// if the subject line is in the format of: '/^(\+[0-9]+) ?([a-zA-Z0-9_-]+)?/'
// eg. subject: +4477777777 john
$allow_forwarded_sms = 1;

// leave mail on server
// feature added: 8-SEP-2001 (0.3)
// changing this to 0 will delete email from the mail account
// and will also delete existing messages that are still on
// the mail server
$leave_mail_on_server = 1;

// script time out (used every time a POP3 function is executed)
$time_limit = 60;

// error retries
// each time script is run a counter in config is incremented.
// when the script finishes the counter is reset.
// if there's a problem it will keep incrementing
// set the limit here so script can send out a warning
// email to admin and stop processing when it reaches this number.
$error_retries = 7;

// emails which have NOT got the specific SMS
// subject line will go to this number
// empty string == ignore these messages
$admin_mobile = "+441234567890";

// admin email address
$admin_email = "you@domain.com";

// how many messages should it process on each run?
// 0 = all
$sends_per_exec = 3;

// how many lines to grab from the body of the email
$body_lines = 10;

// pop_echo will output text on what was sent
// pop_none will not
$output = "pop_echo";


//-------------------------------------------------
//-- SMS SETTINGS (www.mtnsms.com account required)
//-------------------------------------------------
$sms_email = "you@domain.com";		// MTNSMS login email address
$sms_password = "passs";			// MTNSMS password
$sms_glob_signature = "sms";		// Signature for text message
$sms_debug = FALSE;					// Debugging messages not displayed
$sms_additional_login = array();	// holds additional login details

// uncomment lines below if you want to include additional MTNSMS accounts
// incase the one above fails

// $sms_additional_login[] = array("email2@domain.com", "password2");
// $sms_additional_login[] = array("email3@domain.com", "password3");
// $sms_additional_login[] = array("email4@domain.com", "password4");

$sms_server = array();				// holds MTNSMS servers
$sms_server[] = "www.mtnsms.com";
$sms_server[] = "www1.mtnsms.com";
$sms_server[] = "www2.mtnsms.com";
$sms_server[] = "www3.mtnsms.com";
$sms_server[] = "www4.mtnsms.com";

//-------------------------------------------------
//-- POP3 SETTINGS
//-------------------------------------------------
$pop_server = "mail.domain.com";
$pop_port = "110";
$pop_login = "email_account@domain.com";
$pop_pass = "pass";
$pop_debug = FALSE;




//-------------------------------------------------
//-- FUNCTIONS FOLLOW, NO NEED TO EDIT
//-------------------------------------------------





//-------------------------------------------------
//-- OUTPUT FUNCTIONS (depending on $output will
//-- either echo the text or not)
//-------------------------------------------------
function pop_echo($msg) {
	echo $msg;
}

function pop_none($msg) {
	
}

//-------------------------------------------------
//-- CONFIG FUNCTIONS (retrieval and update of config)
//-------------------------------------------------

// retrieves vars in config file
// and assigns them into global space
function retrieve_config($filename) { 
	if (!file_exists($filename)) {
		die("config not found");
	}
	$fp = fopen($filename, "r"); 
	$data = fread($fp, filesize($filename)); 
	fclose($fp);
	$config = @unserialize($data);
	
	if (!is_array($config)) {
		die("config empty, run reset_config.php (or whatever you've called it)");
	}

	while(list($name, $value) = each($config)) {
		global $$name;
		$$name = $value;
	}

	return $config["config_array"];
} 

// updates config file with new vars and values
function update_config($filename, $config_array) { 
	@touch($filename) or die("Error creating / touching file");
	$data = serialize($config_array);
	$fp = fopen($filename, "w"); 
	fwrite($fp, $data); 
	fclose($fp); 
} 


?>